
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
ContactPoint::ContactPoint() 
{
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
ContactPoint::ContactPoint( VuVec &P, VuVec &N, float D )
{		
	mPoints[0] = P;
	mNormal = N;
	mDepth = D;
	mNormal.Normalise();
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
ContactPoint::ContactPoint( const VuVec &P, const VuVec &N, float D , GhkFeature *Fa, GhkFeature *Fb , int hash)
{
	Init( P,N,D,Fa,Fb, hash );
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
void ContactPoint::Init( const VuVec &P, const VuVec &N, float D , GhkFeature *Fa, GhkFeature *Fb , int hash)
{
	Init( P, P, N, D );
	Init( (Geom*) Fa->Owner, (Geom*) Fb->Owner );

	//If triangles, store the owner pointer instead.
	for (int i=0; i<2; i++)
		if (mGeoms[i]->GetType() == Geom::TRIANGLE)
			mGeoms[i] = ((TriangleGeom*) mGeoms[i])->Owner;

	//Build a unique ish hash. 
	//This relies on only one of the features have a tri index.
	mHash = hash;
	mHash |= Fa->TriIndex << 16;
	mHash |= Fb->TriIndex << 16;
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
void ContactPoint::Init( Geom* Ga, Geom* Gb )
{
	NuAssert( Ga && Gb, "Null Geoms Not Allowed");
	Init( 0, Ga, Ga->GetMaterial(), Ga->GetTerrType(), Ga->GetTerrExtra() );
	Init( 1, Gb, Gb->GetMaterial(), Gb->GetTerrType(), Gb->GetTerrExtra() );

	SetChildIxs( Ga->GetChildIx(), Gb->GetChildIx() );
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
void ContactPoint::Init( const VuVec &Pa, const VuVec &Pb, const VuVec &N, Geom* Ga, Geom* Gb, float Depth )
{
	Init( Pa,Pb,N, Depth );
	Init( Ga,Gb );
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
void ContactPoint::Init( const VuVec &Pa, const VuVec &Pb, const VuVec &N, float Depth )
{
	//NuAssert( (Pb-Pa).DotProduct( N ) * Depth <= FLT_EPSILON, "Normal should point from from object A to object B");
	mNormal = N;
	mDepth = Depth;
	mPoints[0] = Pa;
	mPoints[1] = Pb;		
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
void ContactPoint::Init( int i, Geom* G, char Mat, Geom::TerrType Ter, Geom::TerrExtra Flag )
{
	mGeoms[i] = G;		
	mFlags[i] = Flag;
	mMaterials[i] = Mat;	
	mTerrTypes[i] = Ter;
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
void ContactPoint::SetChildIxs( int ChildA, int ChildB )
{
	mChildIndex[0] = ChildA;
	mChildIndex[1] = ChildB;
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
int	ContactPoint::GetChildIxA() { return mChildIndex[0]; }
int ContactPoint::GetChildIxB() { return mChildIndex[1]; }

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
const VuVec& ContactPoint::Normal() { return mNormal; }

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
const VuVec& ContactPoint::PointA() { return mPoints[0]; }
const VuVec& ContactPoint::PointB() { return mPoints[1]; }

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
Geom* ContactPoint::GeomA()	{ return mGeoms[0]; }
Geom* ContactPoint::GeomB()	{ return mGeoms[1]; }

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
Entity* ContactPoint::EntityA() { return mGeoms[0]->GetEntity(); }
Entity* ContactPoint::EntityB() { return mGeoms[1]->GetEntity(); }
	
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
const Geom::TerrExtra	ContactPoint::TExtraA() { return mFlags[0]; }
const Geom::TerrExtra	ContactPoint::TExtraB() { return mFlags[1]; }

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
const char ContactPoint::DynoMatA()	{ return mMaterials[0]; }
const char ContactPoint::DynoMatB()	{ return mMaterials[1]; }

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
const char ContactPoint::TTypeA()	{ return mTerrTypes[0]; }
const char ContactPoint::TTypeB()	{ return mTerrTypes[1]; }

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
float ContactPoint::Depth() 
{ 
	return mDepth; 
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
float ContactPoint::Dist() 
{ 
	return -mDepth; 
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
unsigned int ContactPoint::Hash() 
{ 
	return mHash; 
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
void ContactPoint::OverrideGeom( int i, Geom* G )
{
	mGeoms[i] = G;
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
void ContactPoint::SetPointA( const VuVec &A )
{
		mPoints[0] = A;
	}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
void ContactPoint::SetDepth( float NewDepth )
{
	mDepth = NewDepth;
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
void ContactPoint::SetNormal( const VuVec &NewNorm )
{
	mNormal = NewNorm;
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
void ContactPoint::Swap()
{
		ContactPoint NewP = *this;
		mDepth = NewP.mDepth;
		mNormal = -NewP.mNormal;				
		mPoints[0] = NewP.mPoints[1];
		mPoints[1] = NewP.mPoints[0];
		mGeoms[0] = NewP.mGeoms[1];
		mGeoms[1] = NewP.mGeoms[0];	
		mFlags[0] = NewP.mFlags[1];
		mFlags[1] = NewP.mFlags[0];
		mMaterials[0] = NewP.mMaterials[1];	
		mMaterials[1] = NewP.mMaterials[0];	
		mTerrTypes[0] = NewP.mTerrTypes[1];
		mTerrTypes[1] = NewP.mTerrTypes[0];
	}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
	inline int& ContactPoint::ClusterIndex()
	{
		return (*(int*)&mPoints[0].w);
	}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
void ContactPoint::Render()
{
	RenderPoint( mPoints[0], 0.01f, 0xffffffff );	
	RenderLine( mPoints[0], mPoints[0] + mNormal );
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
void ContactPoint::SetVertIds( int IdsA[3], int IdsB[3] )
{
	mVertIds[0][0] = IdsA[0];
	mVertIds[0][1] = IdsA[1];
	mVertIds[0][2] = IdsA[2];

	mVertIds[1][0] = IdsB[0];
	mVertIds[1][1] = IdsB[1];
	mVertIds[1][2] = IdsB[2];
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
void ContactPoint::GetVertIds( int IdsA[3], int IdsB[3] )
{
	IdsA[0] = mVertIds[0][0];
	IdsA[1] = mVertIds[0][1];
	IdsA[2] = mVertIds[0][2];

	IdsB[0] = mVertIds[1][0];
	IdsB[1] = mVertIds[1][1];
	IdsB[2] = mVertIds[1][2];
}
